/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8271k;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.AccessDenied;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.eui.WrongSysOidMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.launcher.LaunchContext;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.CookieTray;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class BoxInfo {
    private static ResourceBundle myBundle;
    private static String bundleName;
    public static final String PROPNAME = "BoxInfo.jdm8271k.nways.ibm";
    public static final String serPath = "ibm.nways.jdm8271k.WCDefault";
    public static final int MAX_NUM_OF_MOD_PORTS = 32;
    private static final int SUCCESSFUL = 0;
    private static final int FAILED = 1;
    private static final int RASID = 19;
    private static final int RASSUB = 21;
    public static final int NoStatus = 0;
    public static final int AllisWell = 1;
    public static final int NotResponding = 2;
    public static final int WrongBox = 3;
    public static final int ServerProblems = 4;
    OIDInfo oidInfo = new OIDInfo();
    UFCInfo ufcInfo = new UFCInfo();
    private GenModel deviceModel;
    private GenModel portModel;
    private GenModel systemModel;
    private GenModel UFCModel;
    private GenModel interfaceModel;
    private GenModel snmpModel;
    private GenModel portStatusModel;
    private Vector ufcInfoVector;
    private Vector snmpInfoVector;
    private Vector ufcDataVector;
    private JdmBrowser deviceBrowser;
    private int deviceStatus;
    private int retrievalStatus;
    private GraphicPanel deviceGraphic;
    private OID deviceSysOID;
    private int NumOfUFCs;
    private int agentVersion;
    GraphicPanel graphicPanel;
    GraphicContainer grContainer;

    public BoxInfo(GenModel genModel, JdmBrowser jdmBrowser) {
        ModelInfo modelInfo = null;
        Serializable serializable = null;
        this.ufcDataVector = new Vector();
        this.deviceBrowser = jdmBrowser;
        this.deviceModel = genModel;
        myBundle = ResourceBundle.getBundle(bundleName);
        try {
            modelInfo = this.deviceModel.getInfo("Initial");
            serializable = modelInfo.get("Initial.SysObjectID");
            if (serializable instanceof Timeout || serializable instanceof NotSupported || serializable instanceof AccessDenied) {
                this.deviceStatus = 2;
                if (RAS.isEnabled(19, 21)) {
                    RAS.trace(19, 21, this, "BoxInfo", "Device not responding" + serializable.toString());
                }
                new BoxDownMsg(jdmBrowser.getFrame(), myBundle.getString("deviceName"));
                return;
            }
            this.deviceSysOID = new OID(serializable.toString());
            if (this.oidInfo.containsKey(this.deviceSysOID)) {
                this.deviceStatus = 1;
                this.retrievalStatus = this.getNecessaryModels();
                return;
            }
            this.deviceStatus = 3;
            if (RAS.isEnabled(19, 21)) {
                RAS.trace(19, 21, this, "BoxInfo", "Wrong device.  SysOID = " + this.deviceSysOID);
            }
            new WrongSysOidMsg(this.deviceBrowser.getFrame(), myBundle.getString("deviceName"));
            return;
        }
        catch (Exception exception) {
            this.deviceStatus = 4;
            RAS.logError(19, 21, this, "BoxInfo", "EXCEPTION_GETTING_MODELINFO", (Object)"Initial", (Object)"Jdm8271kModel");
            RAS.logException(19, 21, this, "BoxInfo", exception);
            return;
        }
    }

    public static void setInNavContext(NavigationContext navigationContext, BoxInfo boxInfo) {
        navigationContext.put((Object)PROPNAME, (Object)boxInfo);
    }

    public static BoxInfo getFromNavContext(NavigationContext navigationContext, boolean bl) {
        return (BoxInfo)navigationContext.get((Object)PROPNAME, bl);
    }

    public JdmBrowser getDeviceBrowser() {
        return this.deviceBrowser;
    }

    public int getDeviceStatus() {
        return this.deviceStatus;
    }

    public GenModel getDeviceModel() {
        return this.deviceModel;
    }

    public GraphicPanel getDeviceGraphic() {
        if (this.deviceStatus == 1) {
            if (this.deviceGraphic != null) {
                return this.deviceGraphic;
            }
            JdmLayout jdmLayout = (JdmLayout)this.deviceBrowser.getLayout();
            jdmLayout.setScheme(this.oidInfo.getScheme(this.deviceSysOID));
            this.grContainer = new GraphicContainer();
            GraphicHelp graphicHelp = new GraphicHelp((BrowserApplet)this.deviceBrowser, new Point(0, 0), new HelpRef((Object)this));
            this.grContainer.add((GraphicComponent)graphicHelp);
            this.getEthernetUFCInfo();
            this.NumOfUFCs = this.ufcDataVector.size();
            this.grContainer.add((GraphicContainer)this.createModel(this.deviceSysOID));
            this.graphicPanel = new GraphicPanel((GraphicHandler)this.deviceBrowser, (Component)this.grContainer);
        }
        return this.graphicPanel;
    }

    private int getNecessaryModels() {
        int n = 0;
        int n2 = 1;
        if (RAS.isEnabled(19, 21)) {
            RAS.trace(19, 21, this, "getNecessaryModels", "Attempting to retrieve the following components:");
        }
        if (RAS.isEnabled(19, 21)) {
            RAS.trace(19, 21, this, "getNecessaryModels", "PortInfo - System - EsUFC - Interface - Ibm8271eEsSnmpInfo - PortStatus");
        }
        try {
            this.portModel = (GenModel)this.deviceModel.getComponent("PortInfo");
            n2 = 2;
            this.systemModel = (GenModel)this.deviceModel.getComponent("System");
            n2 = 3;
            this.UFCModel = (GenModel)this.deviceModel.getComponent("EsUFC");
            n2 = 4;
            this.interfaceModel = (GenModel)this.deviceModel.getComponent("Interface");
            n2 = 5;
            this.snmpModel = (GenModel)this.deviceModel.getComponent("Ibm8271eEsSnmpInfo");
            n2 = 6;
            this.portStatusModel = (GenModel)this.deviceModel.getComponent("PortStatus");
            n = this.getNecessaryVectors();
        }
        catch (Exception exception) {
            n = 1;
            if (n2 == 6) {
                RAS.logError(19, 21, this, "getNecessaryModels", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"PortStatus", (Object)"Jdm8271kModel");
            } else if (n2 == 5) {
                RAS.logError(19, 21, this, "getNecessaryModels", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"Ibm8271eEsSnmpInfo", (Object)"Jdm8271kModel");
            } else if (n2 == 4) {
                RAS.logError(19, 21, this, "getNecessaryModels", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"Interface", (Object)"Jdm8271kModel");
            } else if (n2 == 3) {
                RAS.logError(19, 21, this, "getNecessaryModels", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"EsUFC", (Object)"Jdm8271kModel");
            } else if (n2 == 2) {
                RAS.logError(19, 21, this, "getNecessaryModels", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"System", (Object)"Jdm8271kModel");
            } else {
                RAS.logError(19, 21, this, "getNecessaryModels", "EXCEPTION_GETTING_MODEL_COMPONENT", (Object)"PortInfo", (Object)"Jdm8271kModel");
            }
            RAS.logException(19, 21, this, "getNecessaryModels", exception);
        }
        return n;
    }

    private int getNecessaryVectors() {
        this.ufcInfoVector = new Vector();
        this.snmpInfoVector = new Vector();
        int n = 0;
        try {
            this.ufcInfoVector = this.UFCModel.getRestOfInfo("EsUFCInfo", "default", null, null);
            this.snmpInfoVector = this.snmpModel.getRestOfInfo("Panel", "default", null, null);
        }
        catch (Exception exception) {
            n = 1;
            exception.printStackTrace();
        }
        return n;
    }

    public void setLaunchData(NavigationContext navigationContext) {
        Vector<Properties> vector = new Vector<Properties>();
        if (this.deviceStatus == 1 && this.retrievalStatus == 0) {
            if (RAS.isEnabled(19, 21)) {
                RAS.trace(19, 21, this, "setLaunchData", "Building the Launch Data");
            }
            LaunchContext launchContext = new LaunchContext();
            int n = 0;
            while (n < this.NumOfUFCs) {
                Hashtable hashtable = (Hashtable)this.ufcDataVector.elementAt(n);
                int n2 = (Integer)hashtable.get("SlotNumber");
                String cfr_ignored_0 = (String)hashtable.get("UFCDescr");
                String string = (String)hashtable.get("UFCType");
                if (launchContext.containsKey(string)) {
                    String string2 = launchContext.getName(string);
                    int n3 = 0;
                    while (n3 < this.snmpInfoVector.size()) {
                        int n4;
                        ModelInfo modelInfo = (ModelInfo)this.snmpInfoVector.elementAt(n3);
                        Serializable serializable = modelInfo.get("Panel.Ibm8271eEsSnmpInfoSlotNum");
                        if (serializable instanceof Integer && (n4 = ((Integer)serializable).intValue()) == n2 && (serializable = modelInfo.get("Panel.Ibm8271eEsSnmpInfoEntryNum")) instanceof Integer && (Integer)serializable == 1 && (serializable = modelInfo.get("Panel.Ibm8271eEsSnmpInfoIpAddress")) instanceof IPAddress) {
                            String string3 = ((IPAddress)serializable).toString();
                            String string4 = "Slot " + n2 + " " + string2 + " [" + string3 + "] ";
                            launchContext.setNavTitle(string, string4);
                            launchContext.setSlotNumber(string, new Integer(n2).toString());
                            launchContext.setIpAddress(string, string3);
                            Properties properties = launchContext.getProp(string);
                            vector.addElement(properties);
                        }
                        ++n3;
                    }
                }
                ++n;
            }
        }
        navigationContext.put((Object)"launcherFolderContext", vector);
    }

    public void dispose() {
        if (this.deviceGraphic != null) {
            this.deviceGraphic.dispose();
            this.deviceGraphic = null;
        }
    }

    public CookieTray createModel(OID oID) {
        Vector vector;
        Vector vector2;
        Vector vector3;
        Integer n;
        Serializable serializable;
        Object object;
        WidgetCookie widgetCookie;
        String string;
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        Integer n5 = new Integer(-99);
        Vector<Integer> vector4 = new Vector<Integer>(this.NumOfUFCs);
        String string2 = new String();
        String string3 = new String("ibm.nways.jdm8271k.eui.PortInfoPanel");
        String string4 = new String("/ibm/nways/jdm8271k/" + this.oidInfo.getImage(oID));
        String string5 = new String(this.oidInfo.getModel(oID));
        this.oidInfo.getOrientation(oID);
        int n6 = this.oidInfo.getNumPorts(oID);
        Point point = new Point(-1, -1);
        try {
            string2 = new String(string5.substring(5));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            ++n4;
            if (RAS.isEnabled(19, 21)) {
                RAS.trace(19, 21, this, "createModel", "An exception occurred while attempting to retrieve info");
            }
            RAS.logException(19, 21, this, "createModel", (Exception)stringIndexOutOfBoundsException);
        }
        if (RAS.isEnabled(19, 21)) {
            RAS.trace(19, 21, this, "createModel", "Attempting to display " + string5);
        }
        CookieTray cookieTray = new CookieTray(bundleName, this.oidInfo.getPosition(oID), string4, string5, this.deviceBrowser, this.systemModel, "ibm.nways.mib2.eui.SystemPanel");
        int n7 = 0;
        while (n7 < this.oidInfo.getNumOfExtras(oID)) {
            string = new String("r" + string2 + this.oidInfo.getExtras(oID, n7));
            try {
                widgetCookie = new WidgetCookie(string, bundleName, null, serPath, null, this.deviceBrowser, 22, string3);
                cookieTray.AddWidget(widgetCookie);
            }
            catch (NullPointerException nullPointerException) {
                ++n4;
                if (RAS.isEnabled(19, 21)) {
                    RAS.trace(19, 21, this, "createModel", "Null pointer exception incurred while attempting to create WidgetCookie " + string);
                }
                RAS.logException(19, 21, this, "createModel", (Exception)nullPointerException);
            }
            ++n7;
        }
        if (n4 > 0) {
            return cookieTray;
        }
        int n8 = 0;
        while (n8 < this.NumOfUFCs) {
            new String((String)((Hashtable)this.ufcDataVector.elementAt(n8)).get("UFCDescr"));
            OctetString octetString = new OctetString((OctetString)((Hashtable)this.ufcDataVector.elementAt(n8)).get("UFCType"));
            object = new String("/ibm/nways/gifs/24_scale/" + this.ufcInfo.getImage(octetString, this.oidInfo.getOrientation(oID)));
            int n9 = (Integer)((Hashtable)this.ufcDataVector.elementAt(n8)).get("SlotNumber");
            if (n9 != 1 + this.oidInfo.getNumSlots(oID)) {
                int n10 = 0;
                serializable = new Point(this.oidInfo.getSlotCoords(oID, n9));
                if (!((Point)serializable).equals(point)) {
                    n = new CookieTray(bundleName, (Point)serializable, (String)object, this.ufcInfo.getName(octetString), this.deviceBrowser, this.UFCModel, "ibm.nways.jdm8271k.eui.UFCPanel");
                    while ((n10 = n9 - vector4.size()) > 0) {
                        vector4.addElement(null);
                    }
                    vector4.addElement(n);
                }
            }
            ++n8;
        }
        if (n4 > 0) {
            return cookieTray;
        }
        try {
            vector3 = this.portModel.getRestOfInfo("PortTypNum", "default", null, null);
        }
        catch (Exception exception) {
            RAS.logError(19, 21, this, "createModel", "EXCEPTION_GETTING_MODELINFO", (Object)"PortTypeNum", (Object)"PortInfoModel");
            RAS.logException(19, 21, this, "createModel", exception);
            ++n4;
            vector3 = new Vector();
        }
        try {
            vector2 = this.interfaceModel.getRestOfInfo("Panel", "default", null, null);
        }
        catch (Exception exception) {
            RAS.logError(19, 21, this, "createModel", "EXCEPTION_GETTING_MODELINFO", (Object)"Panel", (Object)"InterfaceModel");
            RAS.logException(19, 21, this, "createModel", exception);
            ++n4;
            vector2 = new Vector();
        }
        try {
            vector = this.portStatusModel.getRestOfInfo("Panel", "default", null, null);
        }
        catch (Exception exception) {
            RAS.logError(19, 21, this, "createModel", "EXCEPTION_GETTING_MODELINFO", (Object)"Panel", (Object)"PortStatus");
            RAS.logException(19, 21, this, "createModel", exception);
            ++n4;
            vector = new Vector();
        }
        if (RAS.isEnabled(19, 21)) {
            RAS.trace(19, 21, this, "createModel", "Interface info size = " + vector2.size());
        }
        if (RAS.isEnabled(19, 21)) {
            RAS.trace(19, 21, this, "createModel", "Ports info size = " + vector3.size());
        }
        if (n4 > 0) {
            return cookieTray;
        }
        int n11 = 1;
        while (n11 <= vector.size()) {
            object = new ModelInfo();
            ModelInfo modelInfo = new ModelInfo();
            ModelInfo modelInfo2 = (ModelInfo)vector.elementAt(n11 - 1);
            serializable = (Integer)modelInfo2.get("Index.Ibm8271eEsPortNumber");
            n = (Integer)modelInfo2.get("Index.Ibm8271eEsPortSwitchNumber");
            Integer n12 = (Integer)modelInfo2.get("Panel.Ibm8271eEsPortType");
            Integer n13 = (Integer)modelInfo2.get("Panel.Ibm8271eEsPortModNumber");
            if (RAS.isEnabled(19, 21)) {
                RAS.trace(19, 21, this, "getting rows", "port number =" + serializable);
                RAS.trace(19, 21, this, "getting rows", "switch number =" + n);
                RAS.trace(19, 21, this, "getting rows", "port Type =" + n12);
                RAS.trace(19, 21, this, "getting rows", "mod number =" + n13);
            }
            if (n13 != 1 + this.oidInfo.getNumSlots(oID)) {
                String string6;
                boolean bl = false;
                ((ModelInfo)object).add("Index.PortIdx", serializable);
                ((ModelInfo)object).add("Index.SwitchIdx", n);
                if (!n12.equals(n5)) {
                    n2 = 1;
                }
                if ((Integer)serializable <= n6 && n12 == 1) {
                    n3 = n11;
                    string6 = new String("00" + n11);
                    new Integer(string6);
                    modelInfo.add("Index.Ibm8271eEsPortSwitchNumber", n);
                    modelInfo.add("Index.Ibm8271eEsPortNumber", serializable);
                    string = new String("r" + string2 + "Port" + n11);
                    try {
                        widgetCookie = new WidgetCookie(string, bundleName, modelInfo, serPath, this.portStatusModel, this.deviceBrowser, 18);
                        cookieTray.AddWidget(widgetCookie);
                        widgetCookie.SetAction(this.portModel, (ModelInfo)object, string3);
                    }
                    catch (NullPointerException nullPointerException) {
                        ++n4;
                        if (RAS.isEnabled(19, 21)) {
                            RAS.trace(19, 21, this, "createModel", "Null pointer exception incurred while attempting to create WidgetCookie " + string);
                        }
                        RAS.logException(19, 21, this, "createModel", (Exception)nullPointerException);
                    }
                } else {
                    switch (n12) {
                        case 3: {
                            bl = true;
                            string = "100BASETXPort1";
                            break;
                        }
                        case 4: {
                            bl = true;
                            string = "100BASEFXPort1";
                            break;
                        }
                        case 5: {
                            bl = true;
                            string = new String("10BASETPort" + n2);
                            break;
                        }
                        case 7: {
                            bl = true;
                            string = new String("10BASEFLPort" + n2);
                            break;
                        }
                        case 8: {
                            bl = true;
                            string = "155ATMPort1";
                            break;
                        }
                        case 9: {
                            string = "unknown";
                            break;
                        }
                        case 10: {
                            string = "LanEmulation";
                            break;
                        }
                        case 11: {
                            string = "MssLanPort";
                            break;
                        }
                        default: {
                            string = "unknown";
                        }
                    }
                    if (bl) {
                        String string7;
                        if (n2 < 10) {
                            string7 = new String("0" + n2);
                            string6 = new String(String.valueOf(n13.toString()) + string7);
                        } else {
                            string7 = new Integer(n2).toString();
                            string6 = new String(String.valueOf(n13.toString()) + string7);
                        }
                        new Integer(string6);
                        modelInfo.add("Index.Ibm8271eEsPortSwitchNumber", n);
                        modelInfo.add("Index.Ibm8271eEsPortNumber", serializable);
                        string = this.oidInfo.getOrientation(oID).equals("HORIZONTAL") ? new String("h" + string) : new String("v" + string);
                        widgetCookie = new WidgetCookie(string, bundleName, modelInfo, serPath, this.portStatusModel, this.deviceBrowser, 18);
                        widgetCookie.SetFlyover("Port", ((Integer)serializable).intValue());
                        widgetCookie.SetAction(this.portModel, (ModelInfo)object, string3);
                        ((CookieTray)vector4.elementAt(n13)).AddWidget(widgetCookie);
                    }
                }
                n5 = n12;
            }
            ++n11;
            ++n2;
        }
        int n14 = 0;
        while (n14 < vector4.size()) {
            if (vector4.elementAt(n14) != null) {
                cookieTray.add((GraphicContainer)((CookieTray)vector4.elementAt(n14)));
            }
            ++n14;
        }
        return cookieTray;
    }

    public void getEthernetUFCInfo() {
        Hashtable<String, Object> hashtable = null;
        if (RAS.isEnabled(19, 21)) {
            RAS.trace(19, 21, this, "getEthernetUFCInfo", "Getting the UFC information");
        }
        int n = 0;
        while (n < this.ufcInfoVector.size()) {
            ModelInfo modelInfo = (ModelInfo)this.ufcInfoVector.elementAt(n);
            hashtable = new Hashtable<String, Object>();
            Serializable serializable = modelInfo.get("EsUFCInfo.EsUFCSlotNum");
            if (serializable instanceof Integer) {
                hashtable.put("SlotNumber", (Integer)serializable);
            } else {
                hashtable.put("SlotNumber", new Integer(-1));
            }
            serializable = modelInfo.get("EsUFCInfo.EsUFCTypeDescr");
            if (serializable instanceof String) {
                hashtable.put("UFCDescr", (String)((Object)serializable));
            } else {
                hashtable.put("UFCDescr", new String("-"));
            }
            serializable = modelInfo.get("EsUFCInfo.EsUFCType");
            if (serializable instanceof OctetString) {
                if (serializable.toString().equals("cf")) {
                    if (((String)hashtable.get("UFCDescr")).startsWith("MSS D")) {
                        hashtable.put("UFCType", new OctetString("c2"));
                    } else {
                        hashtable.put("UFCType", new OctetString("ff"));
                    }
                } else {
                    hashtable.put("UFCType", (OctetString)serializable);
                }
            } else {
                hashtable.put("UFCType", new OctetString("ff"));
            }
            this.ufcDataVector.addElement(hashtable);
            ++n;
        }
    }

    static {
        bundleName = "ibm.nways.jdm8271k.GeneralResources";
    }

    private class OIDTable
    extends Hashtable {
        public void create(OID oID) {
            try {
                this.put(oID, new Hashtable());
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }

        public Hashtable getHash(OID oID) {
            return (Hashtable)this.get(oID);
        }

        OIDTable() {
            BoxInfo.this = BoxInfo.this;
        }
    }

    private class OIDInfo {
        OIDTable oidTable;

        public OIDInfo() {
            BoxInfo.this = BoxInfo.this;
            this.oidTable = new OIDTable();
            OID oID = new OID("1.3.6.1.4.1.2.6.98.1.1.108");
            Integer n = new Integer(1);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8271-108");
            this.oidTable.getHash(oID).put("Image", "8271-108.gif");
            this.oidTable.getHash(oID).put("Position", new Point(30, 25));
            this.oidTable.getHash(oID).put("Scheme", new Integer(0));
            this.oidTable.getHash(oID).put("Orientation", "HORIZONTAL");
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(313, 5));
            this.oidTable.getHash(oID).put("Number of Ports", new Integer(8));
            this.oidTable.getHash(oID).put("Number of extra stuff", new Integer(5));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Power");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Reset");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Probe");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("AUI");
            oID = new OID("1.3.6.1.4.1.2.6.98.1.1.212");
            n = new Integer(2);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8271-212");
            this.oidTable.getHash(oID).put("Image", "8271-212.gif");
            this.oidTable.getHash(oID).put("Position", new Point(30, 25));
            this.oidTable.getHash(oID).put("Scheme", new Integer(1));
            this.oidTable.getHash(oID).put("Orientation", "VERTICAL");
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(37, 279));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(37, 28));
            this.oidTable.getHash(oID).put("Number of Ports", new Integer(12));
            this.oidTable.getHash(oID).put("Number of extra stuff", new Integer(1));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            oID = new OID("1.3.6.1.4.1.2.6.98.1.1.216");
            n = new Integer(2);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8271-216");
            this.oidTable.getHash(oID).put("Image", "8271-216.gif");
            this.oidTable.getHash(oID).put("Position", new Point(30, 25));
            this.oidTable.getHash(oID).put("Scheme", new Integer(0));
            this.oidTable.getHash(oID).put("Orientation", "HORIZONTAL");
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(57, 5));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(313, 5));
            this.oidTable.getHash(oID).put("Number of Ports", new Integer(16));
            this.oidTable.getHash(oID).put("Number of extra stuff", new Integer(6));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Power");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Reset");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("Probe");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("AUI");
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RJ45");
            oID = new OID("1.3.6.1.4.1.2.6.98.1.1.412");
            n = new Integer(4);
            this.oidTable.create(oID);
            this.oidTable.getHash(oID).put("Model", "8271-412");
            this.oidTable.getHash(oID).put("Image", "8271-412.gif");
            this.oidTable.getHash(oID).put("Position", new Point(30, 25));
            this.oidTable.getHash(oID).put("Scheme", new Integer(1));
            this.oidTable.getHash(oID).put("Orientation", "VERTICAL");
            this.oidTable.getHash(oID).put("Number of Slots", n);
            this.oidTable.getHash(oID).put("Coords for Slot", new Vector(n));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(37, 279));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(37, 28));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(73, 279));
            ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).addElement(new Point(73, 28));
            this.oidTable.getHash(oID).put("Number of Ports", new Integer(12));
            this.oidTable.getHash(oID).put("Number of extra stuff", new Integer(1));
            this.oidTable.getHash(oID).put("Extras", new Vector());
            ((Vector)this.oidTable.getHash(oID).get("Extras")).addElement("RS232");
        }

        public String getModel(OID oID) {
            return (String)this.oidTable.getHash(oID).get("Model");
        }

        public String getImage(OID oID) {
            return (String)this.oidTable.getHash(oID).get("Image");
        }

        public Point getPosition(OID oID) {
            return (Point)this.oidTable.getHash(oID).get("Position");
        }

        public int getScheme(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Scheme");
        }

        public String getOrientation(OID oID) {
            return (String)this.oidTable.getHash(oID).get("Orientation");
        }

        public int getNumSlots(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of Slots");
        }

        public int getNumPorts(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of Ports");
        }

        public Point getSlotCoords(OID oID, int n) {
            if (n - 1 >= ((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).size()) {
                return new Point(-1, -1);
            }
            return (Point)((Vector)this.oidTable.getHash(oID).get("Coords for Slot")).elementAt(n - 1);
        }

        public int getNumOfExtras(OID oID) {
            return (Integer)this.oidTable.getHash(oID).get("Number of extra stuff");
        }

        public String getExtras(OID oID, int n) {
            if (n >= ((Vector)this.oidTable.getHash(oID).get("Extras")).size()) {
                return new String();
            }
            return (String)((Vector)this.oidTable.getHash(oID).get("Extras")).elementAt(n);
        }

        public boolean containsKey(OID oID) {
            return this.oidTable.containsKey(oID);
        }
    }

    private class UFCTable
    extends Hashtable {
        public void create(String string) {
            try {
                this.put(string, new Hashtable());
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
        }

        public Hashtable getProp(String string) {
            if (this.containsKey(string)) {
                return (Hashtable)this.get(string);
            }
            return (Hashtable)this.get("ff");
        }

        UFCTable() {
            BoxInfo.this = BoxInfo.this;
        }
    }

    private class UFCInfo {
        UFCTable ufcTypes;

        public UFCInfo() {
            BoxInfo.this = BoxInfo.this;
            this.ufcTypes = new UFCTable();
            String string = new String("ff");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "UFC Blank Cover");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/hUFCBlankCover.gif");
            this.ufcTypes.getProp(string).put("VERTICAL Image", "vertical/vUFCBlankCover.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(2));
            string = new String("c0");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "1-Port 155 Mbps ATM");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h1Port155MbpsATM.gif");
            this.ufcTypes.getProp(string).put("VERTICAL Image", "vertical/v1Port155MbpsATM.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(1));
            string = new String("c1");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "1-Port 155 Mbps ATM");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h1Port155MbpsATM.gif");
            this.ufcTypes.getProp(string).put("VERTICAL Image", "vertical/v1Port155MbpsATM.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(1));
            string = new String("03");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "1-Port 100BASE-TX");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h1Port100BASETX.gif");
            this.ufcTypes.getProp(string).put("VERTICAL Image", "vertical/v1Port100BASETX.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(1));
            string = new String("06");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "4-Port 10BASE-T");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h4Port10BASET.gif");
            this.ufcTypes.getProp(string).put("VERTICAL Image", "vertical/v4Port10BASET.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(4));
            string = new String("08");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "3-Port 10BASE-FL");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h3Port10BASEFL.gif");
            this.ufcTypes.getProp(string).put("VERTICAL Image", "vertical/v3Port10BASEFL.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(3));
            string = new String("05");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "1-Port 100BASE-FX");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h1Port100BASEFX.gif");
            this.ufcTypes.getProp(string).put("VERTICAL Image", "vertical/v1Port100BASEFX.gif");
            this.ufcTypes.getProp(string).put("Size", new Dimension(243, 36));
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(1));
            string = new String("d7");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "2-Port TR/Enhanced Fiber");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h2PortTREnhancedFiber.gif");
            this.ufcTypes.getProp(string).put("VERTICAL Image", "vertical/v2PortTREnhancedFiber.gif");
            this.ufcTypes.getProp(string).put("Size", new Dimension(243, 36));
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(2));
            string = new String("d9");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "4-Port TR/Enhanced UTP/STP");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/h4PortTREnhancedUTPSTP.gif");
            this.ufcTypes.getProp(string).put("VERTICAL Image", "vertical/v4PortTREnhancedUTPSTP.gif");
            this.ufcTypes.getProp(string).put("Size", new Dimension(243, 36));
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(4));
            string = new String("c2");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "MSS Domain Client");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/hMSSDomainClient.gif");
            this.ufcTypes.getProp(string).put("VERTICAL Image", "vertical/vMSSDomainClient.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(0));
            string = new String("cf");
            this.ufcTypes.create(string);
            this.ufcTypes.getProp(string).put("Name", "MSS Client");
            this.ufcTypes.getProp(string).put("HORIZONTAL Image", "horizontal/hMSSClient.gif");
            this.ufcTypes.getProp(string).put("RIGHT Image", "vertical/vMSSClient.gif");
            this.ufcTypes.getProp(string).put("LEFT Image", "vertical/nMSSClient.gif");
            this.ufcTypes.getProp(string).put("Number of Ports", new Integer(1));
            this.ufcTypes.getProp(string).put("Ports Type", "MSSClient");
        }

        public String getName(OctetString octetString) {
            return (String)this.ufcTypes.getProp(octetString.toString()).get("Name");
        }

        public String getImage(OctetString octetString, String string) {
            String string2 = new String(String.valueOf(string) + " Image");
            return (String)this.ufcTypes.getProp(octetString.toString()).get(string2);
        }

        public int getNumPorts(OctetString octetString) {
            return (Integer)this.ufcTypes.getProp(octetString.toString()).get("Number of ports");
        }
    }
}

